# Library manipulation through scripts

The scripting capabilities can also be used to process the contents of a
library and manipulate them through the use of of various commands. These
include:
* ["Core" GET_ALL_APP_LIBRARIES](Core/GET_ALL_APP_LIBRARIES.md)
* ["Core" GET_CURRENT_LIBRARIES](Core/GET_CURRENT_LIBRARIES.md)
* ["Core" GET_LIBRARY_NAME](Core/GET_LIBRARY_NAME.md)
* ["Core" GET_LIBRARY_ID](Core/GET_LIBRARY_ID.md)
* ["Core" CREATE_CLASS](Core/CREATE_CLASS.md) *
* ["Core" DELETE_CLASS](Core/DELETE_CLASS.md) *
* ["Core" GET_SUPERCLASS_ID](Core/GET_SUPERCLASS_ID.md)
* ["Core" GET_SUPERCLASS_IDS](Core/GET_SUPERCLASS_IDS.md)
* ["Core" GET_SUBCLASS_IDS](Core/GET_SUBCLASS_IDS.md)
* ["Core" CREATE_RELATIONCLASS](Core/CREATE_RELATIONCLASS.md.md) *
* ["Core" DELETE_RELATIONCLASS](Core/DELETE_RELATIONCLASS.md.md) *
* ["Core" CREATE_ATTRIBUTE](Core/CREATE_ATTRIBUTE.md) *
* ["Core" DELETE_ATTRIBUTE](Core/DELETE_ATTRIBUTE.md) *
* ["Core" GET_FACET_VAL](Core/GET_FACET_VAL.md)
* ["Core" SET_FACET_VAL](Core/SET_FACET_VAL.md)

Other more general commands are also necessary for manipulating a library:
* ["Core" GET_CLASS_ID]()
* ["Core" GET_ATTR_ID]()
* ["Core" GET_ATTR_TYPE]()
* ["Core" GET_ATTR_VAL](Core/GET_ATTR_VAL.md)
* ["Core" SET_ATTR_VAL](Core/SET_ATTR_VAL.md)
* ["AdoScript" FWRITE]()

Additional commands that are relevant before and after manipulating a library:
* ["Core" LOAD_LIBRARY](Core/LOAD_LIBRARY.md)
* ["Core" SAVE_LIBRARY](Core/SAVE_LIBRARY.md)
* ["Core" DISCARD_LIBRARY](Core/DISCARD_LIBRARY.md)
* ["Application" RELOAD](Application/RELOAD.md)

> Commands in the lists above marked with an asterisk (*) can only be used when
> the "class hierarchy management" component is enabled. Otherwise they return
> an ecode of 5023.



## General approach to manipulating a library.

The following steps have to be commonly performed to change a part of a
library through scripting commands:
1. Determine ID of library to change.
2. (Development Toolkit only) Load the library.
  - Only one library can be loaded at a time. If a library is already loaded,
    then it should be first discarded.
  - In the Modelling Toolkit the library of the logged in user is loaded.
3. Perform the changes to the library, like:
  - Adding new classes and attributes.
  - Changing the notation (GraphRep) and / or attribute notebook (AttrRep).
  - Modifying the model type definitions ("Modi" library attribute).
  - Modifying the custom functionalities of a library ("External coupling"
    library attribute).
4. Save the library.
5. (Development Toolkit only) Discard the library.
  - Discarding the library does not work in the Modelling Toolkit.
6. Reload the Modelling Toolkit.



## Differences Modelling Toolkit and Development Toolkit

The main differences between using these commands in the Modelling Toolkit and
the Development Toolkit are:
* The Development Toolkit MUST load the application library, before it can
  execute commands accessing specific contents of a library. The Modelling
  Toolkit has only access to the currently loaded library, i.e. the one used by
  the logged in user, and it CAN NOT discard the library.
* The `"Core" SET_ATTR_VAL` also has to use the `create-save-action` parameter
  when modifying attributes of elements on "library" level, e.g. the "Modi"
  attribute of the dynamic library, the default values of attributes, attribute
  facets etc.
* The Development Toolkit loads the state of an application library when its
  contents are first opened, e.g. opening the class hierarchy, the library
  attributes etc. This state is stored until the Development Toolkit is closed
  or a different library has to be loaded. So changes to a library via the
  Modelling Toolkit might not be directly apparent in the Development Toolkit.

> To execute the examples in the Development Toolkit, place them in a file in
> the installation directory and start the Development Toolkit through a
> command line interface (CLI) using a command like:
> `echo EXECUTE file:"test.asc" | aadma.exe -dadodb2 -uAdmin -ppassword -e`



## Accessing and changing library attributes

It is possible to change the values of library attributes, e.g. "Modi" or
"External coupling" using the `"Core" SET_ATTR_VAL` command. In such a case the
class ID of the corresponding library has to be used as the object ID of the
command. It is also necessary to specify the `create-save-action` parameter to
later persist the change through `"Core" SAVE_LIBRARY`. For example:

```AdoScript
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
CC "Core" GET_CLASS_ID objid:(idCurBpLib)
SETL idCurBpLibClass:(classid)
CC "Core" GET_ATTR_ID classid:(idCurBpLibClass) attrname:("Modi")
SETL idModi:(attrid)
CC "Core" SET_ATTR_VAL objid:(idCurBpLib) attrid:(idModi) create-save-action
    val:(newModiValue)
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
```

Getting the value of a library attribute is possible in a similar manner with
the `"Core" GET_ATTR_VAL` command.



## Changing default values of attributes

Changing default values for other attributes is also possible using the
`"Core" SET_ATTR_VAL` command. Note that each class can have a different
default value for an attribute, even inherited attributes. Use the class ID of
the class whose default attribute value should be changed as the object ID of
the command. It is also necessary to specify the `create-save-action` parameter
to later persist the change through `"Core" SAVE_LIBRARY`. For example:

```AdoScript
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
CC "Core" GET_CLASS_ID classname:("TestClass")
SETL idClass:(classid)
CC "Core" SET_ATTR_VAL objid:(idClass) attrname:("GraphRep") create-save-action
    val:("GRAPHREP\n" +
        "SHADOW off\n\n" +
        "PEN style:solid\n" +
        "FILL color:(\"blue\")\n" +
        "RECTANGLE x:-1cm y:-0.5cm w:2cm h:1cm")
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
```

Getting the default value of an attribute is possible in a similar manner with
the `"Core" GET_ATTR_VAL` command.

Note that some types of attributes expect a specific structure as the default
value, e.g. attributes of type PROGRAMCALL.



## Sources for issues and errors

Modifying the meta-model can be dangerous, especially when deleting elements or
removing parts from a configuration of the library. Deleting a part that is
used somewhere else in the configuration of a library can prevent the Modelling
Toolkit from starting or from accessing certain parts, due to the errors this
creates when loading the library. The same is true for the Development Toolkit,
however there it is easier to fix such errors. Common issues can be caused by:
* The "Modi" (model type) configuration referencing a class that doesn't exist.
* An AttrRep or GraphRep referencing an attribute that doesn't exist.
* An INTERREF domain referencing a class or model type that is not available in
  the "Modi" configuration.
* ...

Furthermore deleting a class, attribute or model type does not necessarily
delete any existing objects. What specifically is deleted and what not is
currently unknown. Also changing a model type name doesn't update the type of
existing models and makes them unaccessible.
